IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_SINTEGRA_REG_60I')
	DROP FUNCTION [dbo].[UFD_SINTEGRA_REG_60I]
GO
--select * from UFD_SINTEGRA_REG_60I(1,2,'2015-07-01','2015-07-31')
CREATE FUNCTION [dbo].[UFD_SINTEGRA_REG_60I]( @CD_EMP  INT,  
												 @CD_FILIAL   VARCHAR(50) ,  
												 @CD_CX  INT,
												 @DT_INI      DATETIME,  
												 @DT_FIM      DATETIME)  
--  SELECT * FROM PDV_CX
RETURNS @UFD_RETURN TABLE( 
	  CD_EMP INT ,
	  CD_FILIAL INT,
	  CD_VD INT,
	  ST_VD INT,
	  ST_IT INT,
	  CD_CX INT,
	  DT_EMIS      DATETIME,  
      NR_SERIE   VARCHAR(100), 
	  NR_ECF INT,
	  CD_IT INT,
      CD_PROD   INT,
	  QT_IT INT ,
	  VLR_TOT_IT MONEY, 
	  VLR_BASE_ICMS MONEY,
	  ALIQ_ICMS MONEY,
	  ST_TRIB VARCHAR(4),
	  VLR_ICMS MONEY	  )  

BEGIN  
DECLARE @RS_VD_IT TABLE(
	  CD_EMP INT ,
	  CD_FILIAL INT,
	  CD_VD INT,
	  ST_VD INT,
	  ST_IT INT,
	  CD_CX INT,  
      DT_EMIS      DATETIME,  
      NR_SERIE   VARCHAR(100),
	  NR_ECF INT,
	  CD_IT INT,
      CD_PROD   INT,
	  QT_IT INT ,
	  VLR_TOT_IT MONEY, 
	  VLR_BASE_ICMS MONEY,
	  ALIQ_ICMS MONEY,
	  ST_TRIB VARCHAR(4),
	  VLR_ICMS MONEY)
  
INSERT INTO  
 @RS_VD_IT  

SELECT       
	PDV_VD.CD_EMP,  
	PDV_VD.CD_FILIAL,   
	PDV_VD.CD_VD, 
	PDV_VD.ST_VD , 
	PDV_VD_IT.ST_IT,   
	PDV_VD.CD_CX,
	PDV_VD.DT_VD,
	ISNULL(PDV_CX.NR_SERIE_IMP,'')NR_SERIE_IMP,
	PDV_vD.NR_ECF,
	PDV_VD_IT.CD_IT,
	PDV_VD_IT.CD_PROD,
	SUM(PDV_VD_IT.QT_IT) AS QT_IT,   
	SUM(PDV_VD_IT.TOT_IT) AS VLR_TOT_IT, 
	CASE  WHEN  (ltrim(RIGHT(PDV_VD_IT.CD_TRIB_FC,2))  =  '00'  OR  ltrim(RIGHT(PDV_VD_IT.CD_TRIB_FC,2))  = '20') and coalesce(tipo_imposto,0) = 0  THEN    
		SUM(PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT)  
	ELSE      
	0
	END  AS VLR_BASE_ICMS,
	
	CASE WHEN ISNULL(TIPO_IMPOSTO,0)=1 THEN
		PDV_VD_IT.TX_ICMS_IT    
	WHEN PDV_VD_IT.TX_RED_IT > 0 and RIGHT (PDV_VD_IT.CD_TRIB_FC,2) = '20' THEN        
		PDV_VD_IT.TX_ICMS_IT * PDV_VD_IT.TX_RED_IT/100.000     
	ELSE    
		PDV_VD_IT.TX_ICMS_IT    
	END AS ALIQ_ICMS, 

	CASE WHEN RIGHT(RTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '00' OR RIGHT(RTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '20' THEN
					'T'						
	WHEN RIGHT(RTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '41' OR  RIGHT(RTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '40' THEN
					'I'
	WHEN RIGHT(LTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '10' OR RIGHT(LTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '60' AND RIGHT(LTRIM(PDV_VD_IT.CD_TRIB_FC),2) = '70' OR RIGHT(LTRIM(PDV_VD_IT.CD_TRIB_FC),2) = 60 THEN
					'F'	
	END ST_TRIB,

	CASE WHEN ISNULL(TIPO_IMPOSTO,0)=1 THEN
		SUM(PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT) * (PDV_VD_IT.TX_ICMS_IT/100.0000)  
	WHEN PDV_VD_IT.TX_RED_IT > 0 and RIGHT (PDV_VD_IT.CD_TRIB_FC,2) = '20' THEN    
		SUM((PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT) * (PDV_VD_IT.TX_RED_IT /100.0000))* (PDV_VD_IT.TX_ICMS_IT/100.0000)  
	ELSE    
		SUM(PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT) * (PDV_VD_IT.TX_ICMS_IT/100.0000)  
	END AS VLR_ICMS	 

FROM           
	 PDV_VD INNER JOIN PDV_VD_IT ON
	 PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
	 PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
	 PDV_VD.CD_VD = PDV_VD_IT.CD_VD AND
	 PDV_VD.DT_VD = PDV_VD_IT.DT_VD
	 INNER JOIN PDV_CX ON  
	 PDV_VD.CD_EMP = PDV_CX.CD_EMP AND
	 PDV_VD.CD_FILIAL = PDV_CX.CD_FILIAL AND
	 PDV_VD.CD_CX = PDV_CX.CD_CX    
WHERE         
	PDV_VD_IT.CD_EMP = @CD_EMP    
	AND PDV_VD_IT.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))
	AND PDV_VD_IT.DT_VD BETWEEN @DT_INI AND @DT_FIM   
	AND PDV_VD.CD_CX= @CD_CX
	AND PDV_VD.TIPO = 0
	AND PDV_VD.ST_VD = 0  
	AND PDV_VD_IT.ST_IT = 1
GROUP BY 
	PDV_VD.CD_EMP,  
	PDV_VD.CD_FILIAL,   --  SELECT TOP 2 * FROM PDV_vD_IT 
	PDV_VD.CD_VD, 
	PDV_VD.ST_VD,   
	PDV_VD_IT.ST_IT, 
	PDV_VD.CD_CX,
	PDV_VD.DT_VD,
	PDV_CX.NR_SERIE_IMP,
	PDV_CX.MODELO_ECF,
	PDV_vD.NR_ECF,
	PDV_VD_IT.CD_IT,
	PDV_VD_IT.CD_PROD,
	PDV_VD_IT.CD_TRIB_FC,
    TIPO_IMPOSTO,
	PDV_VD_IT.TX_ICMS_IT ,
	PDV_VD_IT.TX_RED_IT
	
	INSERT INTO @UFD_RETURN  
	SELECT * FROM @RS_VD_IT
	     
RETURN  
END
